/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCreateLiveWOResult;
import filenet.vw.api.VWException;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWQueueStats;
import filenet.vw.api.VWReturnStackElement;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRosterStats;
import filenet.vw.api.VWSecurityDomain;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWTransferResult;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.IVWMemory;
import filenet.vw.base.VWString;
import filenet.vw.rmi.VWUnicastRemoteObject;
import filenet.vw.server.IVWCommand;
import filenet.vw.server.IVWCommandServer;
import filenet.vw.server.IVWServerVersionEx;
import filenet.vw.server.IVWTerminateServer;
import filenet.vw.server.VWCommandResult;
import filenet.vw.server.VWConfigInfo;
import filenet.vw.server.VWConfigResult;
import filenet.vw.server.VWEnvironmentData;
import filenet.vw.server.VWEnvironmentDataQueryResults;
import filenet.vw.server.VWField;
import filenet.vw.server.VWInjectInfo;
import filenet.vw.server.VWLogTableRecord;
import filenet.vw.server.VWLogonCredentials;
import filenet.vw.server.VWLogonHandle;
import filenet.vw.server.VWLogonResult;
import filenet.vw.server.VWNoOnlineClassesException;
import filenet.vw.server.VWOpNotAllowedException;
import filenet.vw.server.VWQueryResults;
import filenet.vw.server.VWQueueMovedException;
import filenet.vw.server.VWQueueRecord;
import filenet.vw.server.VWRosterRecord;
import filenet.vw.server.VWSecurityQueryResults;
import filenet.vw.server.VWServerCommand;
import filenet.vw.server.VWStaleLogonException;
import filenet.vw.server.VWSystemConfigInfo;
import filenet.vw.server.VWSystemWideInfo;
import filenet.vw.server.VWViewDoesNotExistException;
import filenet.vw.server.VWViewIdCommand;
import filenet.vw.server.VWWorkElementFields;
import filenet.vw.server.VWWorkObjectID;
import filenet.vw.server.VWWorkRecord;
import filenet.vw.server.VWWorkSpaceTimeStampStaleException;
import filenet.vw.sysutils.OperatingSystem;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

public class VWServer
extends VWUnicastRemoteObject
implements IVWCommand,
IVWCommandServer,
IVWTerminateServer,
IVWMemory,
IVWServerVersionEx {
    private static final long serialVersionUID = 119175L;
    private int rpcNumber = 0;
    private VWCommandResult commandResult = null;
    private VWServerCommand serverCmd = null;
    private VWLogonHandle logonHandleObj = null;
    private VWException vwExc = null;
    private boolean commandResultAvailable = false;
    private boolean serverCmdAvailable = false;
    private boolean terminateServerObj = false;
    private boolean debugOn;
    private int serverId;
    private static boolean bValidJavaVersion = false;
    private String fnswLocalTmp = "";
    private String fSeparator = null;
    private boolean bVWJAVA_loaded = false;
    private static String EXC_FileName = "jVWServerX.exc";
    public static final String FNVW_prefix = "filenet.vw.vwjs.";
    private static int Info = 0;
    private static int Warning = 1;
    private static int Error = 2;
    private static int Critical = 3;
    private boolean toFNSysLog = false;
    private static SimpleDateFormat timeStampFormatter = new SimpleDateFormat("HH:mm:ss:SSS");
    private static SimpleDateFormat fullDateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");

    public static String _get_FILE_DATE() {
        return "$Date:   17 Oct 2005 15:15:02  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   hakpata  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.196  $";
    }

    public VWServer(boolean bDebugOn, int svrId, String traceDirName) throws RemoteException, VWException {
        this.debugOn = bDebugOn;
        this.serverId = svrId;
        this.fnswLocalTmp = traceDirName;
        try {
            Properties props = System.getProperties();
            this.fSeparator = props.getProperty("file.separator");
            EXC_FileName = this.fnswLocalTmp + this.fSeparator + "jVWServer" + svrId + ".exc";
            String sCurDir = props.getProperty("user.dir");
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("Ctor VWServer(" + String.valueOf(bDebugOn) + ", " + String.valueOf(svrId) + ", " + traceDirName + ")");
            }
            String sOsName = OperatingSystem.getName();
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("property os.name = " + sOsName);
            }
            String sJavaVersion = props.getProperty("java.version");
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("property  java.version = " + sJavaVersion);
            }
            String sJavaVMVersion = props.getProperty("java.vm.version");
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("property  java.vm.version = " + sJavaVMVersion);
            }
            String sJavaVMFileEncoding = props.getProperty("file.encoding");
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("property  file.encoding = " + sJavaVMFileEncoding);
            }
            String sJavaClassPath = props.getProperty("java.class.path");
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("property  java.class.path = " + sJavaClassPath);
            }
            String sJavaLibPath = props.getProperty("java.library.path");
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("property  java.library.path = " + sJavaLibPath);
            }
            String userJavaVersion = null;
            String defaultJavaVersion = null;
            if (OperatingSystem.getType() == OperatingSystem.OS_TYPE_AIX) {
                if (this.debugOn) {
                    this.javaSideLogToVWTRACE("About to call loadLibrary(\"vwjava\") on " + sOsName);
                }
                Runtime.getRuntime().loadLibrary("vwjava");
                defaultJavaVersion = "1.4.2";
            } else if (OperatingSystem.getType() == OperatingSystem.OS_TYPE_HP) {
                if (this.debugOn) {
                    this.javaSideLogToVWTRACE("About to call loadLibrary(\"vwjava\") on " + sOsName);
                }
                Runtime.getRuntime().loadLibrary("vwjava");
                defaultJavaVersion = "1.4.2";
            } else if (OperatingSystem.getType() == OperatingSystem.OS_TYPE_SOLARIS) {
                if (this.debugOn) {
                    this.javaSideLogToVWTRACE("About to call loadLibrary(\"vwjava\") on " + sOsName);
                }
                Runtime.getRuntime().loadLibrary("vwjava");
                defaultJavaVersion = "1.4.2";
            } else {
                if (this.debugOn) {
                    this.javaSideLogToVWTRACE("About to call loadLibrary(\"vwjava_svr\") on " + sOsName);
                }
                Runtime.getRuntime().loadLibrary("vwjava_svr");
                defaultJavaVersion = "1.4.2";
            }
            this.bVWJAVA_loaded = true;
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("After call to loadLibrary");
            }
            VWString warningMsg = null;
            userJavaVersion = this.readJavaVersion();
            if (null == userJavaVersion) {
                bValidJavaVersion = sJavaVersion.indexOf(defaultJavaVersion) >= 0 && sJavaVMVersion.indexOf(defaultJavaVersion) >= 0;
            } else {
                boolean bl = bValidJavaVersion = sJavaVersion.indexOf(userJavaVersion) >= 0 && sJavaVMVersion.indexOf(userJavaVersion) >= 0;
            }
            if (null != userJavaVersion) {
                warningMsg = new VWString("vw.server.UserInvalidJavaOrJavaVMVersion", "Invalid configuration expected JVM version {0} and found version {1}.", defaultJavaVersion, sJavaVMVersion);
            }
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("userJavaVersion = " + userJavaVersion);
            }
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("property  defaultJavaVersion = " + defaultJavaVersion);
            }
            if (!bValidJavaVersion) {
                warningMsg = new VWString("vw.server.InvalidJavaOrJavaVMVersion", "Invalid configuration expected JVM version {0} and found version {1} It is unsafe to continue.", defaultJavaVersion, sJavaVMVersion);
                this.vwExc = new VWException("vw.server.InvalidJavaOrJavaVMVersion", "Invalid Java version or Java VM version, verify that path environment variable and java version are correct -- refer to documentation for your platform.");
            }
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("vwjava library loaded.");
                this.javaSideLogToVWTRACE("user java version=" + userJavaVersion);
                this.javaSideLogToVWTRACE("valid java version?=" + bValidJavaVersion);
                if (!bValidJavaVersion) {
                    this.javaSideLogToVWTRACE(this.vwExc.getMessage());
                    VWServer.dumpExceptionStack(this.vwExc);
                }
            }
            if (null != warningMsg) {
                this.toFNSysLog = true;
                this.messageToLog(this.toFNSysLog, Warning, warningMsg.toString());
                this.toFNSysLog = false;
            }
            this.libInit(this.debugOn);
        }
        catch (UnsatisfiedLinkError linkErr) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("Fatal Error: " + linkErr.getMessage());
                VWServer.dumpExceptionStack(linkErr);
            }
            throw new RemoteException("vw.server.RemoteExceptionVWServer Exception: " + linkErr.getMessage());
        }
        catch (SecurityException sExc) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("Security Exception: " + sExc.getMessage());
            }
            VWServer.dumpExceptionStack(sExc);
            throw new RemoteException("vw.server.RemoteExceptionVWServer Exception: " + sExc.getMessage());
        }
        catch (Exception e) {
            VWServer.dumpExceptionStack(e);
            throw new RemoteException("vw.server.RemoteExceptionVWServer Exception: " + e.getMessage());
        }
        finally {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("Exiting VWServer constructor...");
            }
        }
    }

    public long getRuntimeTotalMemory() throws Exception {
        long totalMemory;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("Entering getRuntimeTotalMemory ");
        }
        try {
            totalMemory = Runtime.getRuntime().totalMemory();
        }
        catch (Exception e) {
            VWServer.dumpExceptionStack(e);
            throw new VWException("vw.server.getRuntimeTotalMemoryFailed", "VWServer Exception: {0}", e.getMessage());
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("Exiting getRuntimeTotalMemory ");
        }
        return totalMemory;
    }

    public long getRuntimeFreeMemory() throws Exception {
        long freeMemory;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("Entering getRuntimeFreeMemory ");
        }
        try {
            freeMemory = Runtime.getRuntime().freeMemory();
        }
        catch (Exception e) {
            VWServer.dumpExceptionStack(e);
            throw new VWException("vw.server.getRuntimeFreeMemoryFailed", "VWServer Exception: {0}", e.getMessage());
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("Exiting getRuntimeFreeMemory ");
        }
        return freeMemory;
    }

    public void checkServerVersion(String serverVersion) throws VWException {
        if (!serverVersion.equals("5.0.0.4")) {
            this.javaSideLogToVWTRACE("VWServer checkServerVersion:Server version is different from credential presented.");
        }
    }

    private String defaultPlatformEncoding() throws VWException {
        String prop = null;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("defaultPlatformEncoding: Entering defaultPlatformEncoding...");
        }
        try {
            prop = System.getProperty("file.encoding");
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.LogoffFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("defaultPlatformEncoding: Exiting defaultPlatformEncoding...");
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCommand(String serverName, VWServer serverObj, Registry serverRegistry) throws VWException {
        VWServer cmdServer = serverObj;
        while (true) {
            VWServer vWServer = serverObj;
            synchronized (vWServer) {
                try {
                    while (!this.serverCmdAvailable && !this.terminateServerObj) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            if (this.debugOn) {
                                this.javaSideLogToVWTRACE(e.getMessage());
                            }
                            VWServer.dumpExceptionStack(e);
                            this.vwExc = new VWException("vw.server.InterruptedException", "VWServer Exception: {0}", e.getMessage());
                        }
                    }
                    this.serverCmdAvailable = false;
                    if (this.terminateServerObj) {
                        if (this.debugOn) {
                            this.javaSideLogToVWTRACE("About to terminate server");
                        }
                        serverRegistry.unbind(serverName);
                        return;
                    }
                    if (this.debugOn) {
                        this.javaSideLogToVWTRACE("performCommand: Current thread: " + Thread.currentThread().toString() + ": thread name: " + Thread.currentThread().getName());
                        this.javaSideLogToVWTRACE("performCommand: About to Perform Command. ");
                    }
                    this.commandResult = this.serverCmd.perform(this.rpcNumber, cmdServer);
                    if (this.debugOn) {
                        this.javaSideLogToVWTRACE("performCommand: Command performed.");
                    }
                    this.vwExc = null;
                }
                catch (Exception e) {
                    if (this.debugOn) {
                        this.javaSideLogToVWTRACE("performCommand: Entering catch...");
                        this.javaSideLogToVWTRACE(e.getMessage());
                    }
                    if (this.debugOn) {
                        VWServer.dumpExceptionStack(e);
                    }
                    this.vwExc = e instanceof VWException ? (VWException)e : (e instanceof VWQueueMovedException ? (VWQueueMovedException)e : (e instanceof VWStaleLogonException ? (VWStaleLogonException)e : (e instanceof VWOpNotAllowedException ? (VWOpNotAllowedException)e : (e instanceof VWWorkSpaceTimeStampStaleException ? (VWWorkSpaceTimeStampStaleException)e : (e instanceof VWViewDoesNotExistException ? (VWViewDoesNotExistException)e : new VWException("vw.server.PerformCommandFailed", "performCommand operation failed: {0}", e.getMessage()))))));
                }
                finally {
                    this.commandResultAvailable = true;
                    this.notifyAll();
                }
            }
        }
    }

    public synchronized boolean terminateServer(boolean terminate) throws RemoteException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("Entering TerminateServer ");
        }
        try {
            if (terminate) {
                this.terminateServerObj = true;
                this.notifyAll();
            }
        }
        catch (Exception e) {
            VWServer.dumpExceptionStack(e);
            throw new RemoteException("vw.server.TerminateServerFailedVWServer Exception: " + e.getMessage());
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("Exiting TerminateServer ");
        }
        return this.terminateServerObj;
    }

    public synchronized byte[] sendCommand(int RPCnumber, byte[] byteCmd, int viewId, byte[][] logonHandles, int[] serverIds) throws RemoteException, VWException {
        byte[] result = null;
        try {
            VWServerCommand cmd = VWServerCommand.fromBytes(byteCmd, RPCnumber);
            if (cmd instanceof VWViewIdCommand) {
                if (this.debugOn) {
                    this.javaSideLogToVWTRACE("sendCommand: View id is: " + viewId);
                }
                ((VWViewIdCommand)cmd).setViewId(viewId);
            }
            if (logonHandles != null) {
                VWLogonHandle lHandleObj = VWLogonHandle.fromBytes(logonHandles[0]);
                if (this.debugOn) {
                    this.javaSideLogToVWTRACE("sendCommand: Logon handle is not null, so set it.");
                    this.javaSideLogToVWTRACE("sendCommand: Logon handle is: " + lHandleObj.toString());
                }
                cmd.setLogonHandle(lHandleObj);
                cmd.setLogonHandleReset(true);
            }
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("sendCommand: Current thread: " + Thread.currentThread().toString() + ": thread name: " + Thread.currentThread().getName());
                if (cmd.commandString != null) {
                    this.javaSideLogToVWTRACE("sendCommand: Command is: " + cmd.commandString.toString());
                }
                this.javaSideLogToVWTRACE("sendCommand: Command received.");
            }
            this.serverCmd = cmd;
            this.rpcNumber = RPCnumber;
            this.serverCmdAvailable = true;
            this.notifyAll();
            while (!this.commandResultAvailable) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (this.debugOn) {
                        this.javaSideLogToVWTRACE(e.getMessage());
                    }
                    VWServer.dumpExceptionStack(e);
                    VWException vwe = new VWException("vw.server.InterruptedException", "VWServer Exception: {0}", e.getMessage());
                    throw vwe;
                }
            }
            this.commandResultAvailable = false;
            VWCommandResult cmdResult = this.commandResult;
            if (this.vwExc != null) {
                if (this.debugOn) {
                    this.javaSideLogToVWTRACE("sendCommand: Entering vwExc != null");
                }
                if (this.debugOn) {
                    VWServer.dumpExceptionStack(this.vwExc);
                }
                if (cmdResult != null) {
                    result = cmdResult.toBytes(RPCnumber);
                }
                throw this.vwExc;
            }
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("sendCommand: Current thread: " + Thread.currentThread().toString() + ": thread name: " + Thread.currentThread().getName());
                this.javaSideLogToVWTRACE("sendCommand: RPC number is: " + RPCnumber);
                this.javaSideLogToVWTRACE("sendCommand: Returning Results.");
            }
            if (cmdResult != null) {
                result = cmdResult.toBytes(RPCnumber);
            }
        }
        catch (Exception e) {
            if (this.debugOn) {
                VWServer.dumpExceptionStack(e);
            }
            if (e instanceof VWQueueMovedException) {
                throw (VWQueueMovedException)e;
            }
            if (e instanceof VWStaleLogonException) {
                throw (VWStaleLogonException)e;
            }
            if (e instanceof VWOpNotAllowedException) {
                throw (VWOpNotAllowedException)e;
            }
            if (e instanceof VWWorkSpaceTimeStampStaleException) {
                throw (VWWorkSpaceTimeStampStaleException)e;
            }
            if (e instanceof VWViewDoesNotExistException) {
                throw (VWViewDoesNotExistException)e;
            }
            throw (VWException)e;
        }
        finally {
            this.commandResult = null;
            this.serverCmd = null;
        }
        return result;
    }

    public VWLogonResult logon(VWLogonHandle logonHandle, VWLogonCredentials logonCredentials) throws VWException {
        VWLogonResult logonResult = null;
        VWLogonHandle lHandle = null;
        Integer isolatedRegion = null;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("logon: Entering logon...");
            this.javaSideLogToVWTRACE("logon: received logonCredentials: " + logonCredentials);
            this.javaSideLogToVWTRACE("logon: security domain=" + logonCredentials.domain);
        }
        try {
            this.checkServerVersion(logonCredentials.getServerVersion());
            if (!bValidJavaVersion) {
                this.vwExc = new VWException("vw.server.InvalidJavaOrJavaVMVersion", "Invalid Java version or Java VM version, verify that path environment variable and java version are correct -- refer to documentation for your platform.");
                throw this.vwExc;
            }
            String name = logonCredentials.getUserName();
            String password = logonCredentials.getPassword();
            String secDomainName = logonCredentials.getDomain();
            long rpcArgFlag = logonCredentials.getArgFlag();
            if (logonHandle == null || logonHandle.getHandle() == 0) {
                if (logonCredentials.IsUserFirstLogon()) {
                    if (this.debugOn) {
                        this.javaSideLogToVWTRACE("logon: doing first logon isolatedReg=" + logonCredentials.isolatedRegion + " userName=" + name + " password=" + (password == null));
                    }
                    isolatedRegion = new Integer(logonCredentials.isolatedRegion);
                    logonResult = this.rootLogon0(isolatedRegion, name, password, secDomainName, rpcArgFlag);
                    logonResult.logonCreds.setUserFirstLogon(logonCredentials.IsUserFirstLogon());
                } else {
                    if (this.debugOn) {
                        this.javaSideLogToVWTRACE("logon: doing secondary logon isolatedReg=" + logonCredentials.isolatedRegion + " userName=" + name + " password=" + (password == null) + " domain=" + secDomainName);
                    }
                    isolatedRegion = new Integer(logonCredentials.isolatedRegion);
                    lHandle = this.logon0(isolatedRegion, name, password, secDomainName, logonCredentials.initTimeStamp, logonCredentials.wsTimeStamp, rpcArgFlag);
                    logonResult = new VWLogonResult(logonCredentials, lHandle);
                }
            } else {
                if (this.debugOn) {
                    this.javaSideLogToVWTRACE("logon: resetting logonHandle in logonResult isolatedReg=" + logonCredentials.isolatedRegion + " userName=" + name + " password=" + (password == null) + " domain=" + secDomainName);
                }
                logonResult = new VWLogonResult(logonCredentials, logonHandle);
            }
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("logon: logonResult.logonHandle: " + logonResult.logonHandle.getHandle());
                this.javaSideLogToVWTRACE("logon: logonResult.logonCreds: " + logonResult.logonCreds);
            }
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.LogonFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("logon: Exiting logon...");
        }
        return logonResult;
    }

    public void logoff(VWLogonHandle logonHandle) throws VWException {
        VWConfigInfo[] queueConfigs = null;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("logoff: Entering logoff...logonHandle=" + logonHandle + "logonHandle=" + logonHandle.getHandle());
        }
        try {
            this.logoff0(new Integer(logonHandle.getHandle()), queueConfigs);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.LogoffFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("logoff: Exiting logoff...");
        }
    }

    public VWConfigResult getConfigInfo(VWLogonHandle logonHandle) throws VWException {
        VWConfigResult configResult = null;
        try {
            configResult = this.getConfigInfo0(new Integer(logonHandle.getHandle()));
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetConfigurationInfoFailed", "VWServer Exception: {0}");
        }
        return configResult;
    }

    public Hashtable getAllServers(VWLogonHandle logonHandle) throws VWException {
        Hashtable servers = null;
        try {
            servers = this.getAllServers0(new Integer(logonHandle.getHandle()));
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetAllServersFailed", "VWServer Exception: {0}");
        }
        return servers;
    }

    public Hashtable getUserNames(VWLogonHandle logonHandle) throws VWException {
        Hashtable userNames = null;
        try {
            userNames = this.getUserNames0(new Integer(logonHandle.getHandle()));
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetUserNamesFailed", "VWServer Exception: {0}");
        }
        return userNames;
    }

    public VWSecurityQueryResults fetchUserList(VWLogonHandle logonHandle, int maxNumToReturn, int queryType, String startRecord, String searchPattern, String domain, int searchType, int sortType, long rpcArgFlag) throws VWException {
        VWSecurityQueryResults queryResults = null;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("fetchUserList:" + queryType);
        }
        try {
            queryResults = this.fetchUserList0(new Integer(logonHandle.getHandle()), maxNumToReturn, queryType, startRecord, searchPattern, domain, searchType, sortType, rpcArgFlag);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.fetchUserListFailed", "VWServer Exception: {0}");
        }
        return queryResults;
    }

    public Boolean recoverUser(VWLogonHandle logonHandle, String userName, String[] queueNames) throws VWException {
        boolean bSuccess = false;
        try {
            bSuccess = this.recoverUser0(new Integer(logonHandle.getHandle()), userName, queueNames);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.RecoverUserNamesFailed", "VWServer Exception: {0}");
        }
        return new Boolean(bSuccess);
    }

    public String[] getQueueNames(VWLogonHandle logonHandle, boolean includeSystemQueues, boolean ignoreSecurity) throws VWException {
        String[] queueNames = null;
        try {
            queueNames = this.getQueueNames0(new Integer(logonHandle.getHandle()), includeSystemQueues, ignoreSecurity);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getQueueNamesFailed", "VWServer Exception: {0}");
        }
        return queueNames;
    }

    public String[] getQueueOperations(VWLogonHandle logonHandle, String queueName) throws VWException {
        String[] operationNames = null;
        try {
            operationNames = this.getQueueOperations0(new Integer(logonHandle.getHandle()), queueName);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getQueueOperationsFailed", "VWServer Exception: {0}");
        }
        return operationNames;
    }

    public String[] getLogNames(VWLogonHandle logonHandle) throws VWException {
        String[] logNames = null;
        try {
            logNames = this.getLogNames0(new Integer(logonHandle.getHandle()));
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getLogNamesFailed", "VWServer Exception: {0}");
        }
        return logNames;
    }

    public String getCurrentVersion(VWLogonHandle logonHandle) throws VWException {
        String currentVersion = null;
        try {
            currentVersion = this.getCurrentVersion0(new Integer(logonHandle.getHandle()));
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getCurrentVersionFailed", "VWServer Exception: {0}");
        }
        return currentVersion;
    }

    public void initializeAllRegions(VWLogonHandle logonHandle) throws VWException {
        try {
            this.initializeAllRegions0(new Integer(logonHandle.getHandle()));
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.initializeAllRegionsFailed", "VWServer Exception: {0}");
        }
    }

    public void initializeRegion(VWLogonHandle logonHandle, boolean emptyIt, int webApp) throws VWException {
        try {
            this.initializeRegion0(new Integer(logonHandle.getHandle()), emptyIt, webApp);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.initializeRegionFailed", "VWServer Exception: {0}");
        }
    }

    public void removeDatabase(VWLogonHandle logonHandle) throws VWException {
        try {
            this.removeDatabase0(new Integer(logonHandle.getHandle()));
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.removeDatabaseFailed", "VWServer Exception: {0}");
        }
    }

    public void setSystemWideConfig(VWLogonHandle logonHandle, VWSystemWideInfo sysInfo) throws VWException {
        try {
            this.setSystemWideConfig0(new Integer(logonHandle.getHandle()), sysInfo);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.setSystemWideConfigFailed", "VWServer Exception: {0}");
        }
    }

    public VWSystemWideInfo getSystemWideConfig(VWLogonHandle logonHandle) throws VWException {
        VWSystemWideInfo theValue = null;
        try {
            theValue = this.getSystemWideConfig0(new Integer(logonHandle.getHandle()));
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getSystemWideConfigFailed", "VWServer Exception: {0}");
        }
        return theValue;
    }

    public Hashtable fetchServerConfiguration(VWLogonHandle logonHandle, String[] keyList) throws VWException {
        Hashtable oHashTable = null;
        try {
            oHashTable = this.fetchServerConfiguration0(new Integer(logonHandle.getHandle()), keyList);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.fetchServerConfigurationFailed", "VWServer Exception: {0}");
        }
        return oHashTable;
    }

    public VWEnvironmentData[] fetchUserInfo(VWLogonHandle logonHandle, String[] theUserNameList) throws VWException {
        VWEnvironmentData[] theValue = null;
        try {
            theValue = this.fetchUserInfo0(new Integer(logonHandle.getHandle()), theUserNameList);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.fetchUserInfoFailed", "VWServer Exception: {0}");
        }
        return theValue;
    }

    public void saveUserInfo(VWLogonHandle logonHandle, VWEnvironmentData theUserInfo) throws VWException {
        try {
            this.saveUserInfo0(new Integer(logonHandle.getHandle()), theUserInfo);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.saveUserInfoFailed", "VWServer Exception: {0}");
        }
    }

    public void deleteUserInfo(VWLogonHandle logonHandle, String theUserName) throws VWException {
        try {
            this.deleteUserInfo0(new Integer(logonHandle.getHandle()), theUserName);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.deleteUserInfoFailed", "VWServer Exception: {0}");
        }
    }

    public VWSystemConfigInfo getSystemConfigInfo(VWLogonHandle logonHandle, int productId) throws VWException {
        VWSystemConfigInfo theResults = null;
        try {
            theResults = this.getSystemConfigInfo0(new Integer(logonHandle.getHandle()), productId);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getSystemConfigInfoFailed", "VWServer Exception: {0}");
        }
        return theResults;
    }

    public VWTransferResult transfer(VWLogonHandle logonHandle, VWLogonCredentials logonCredentials, VWSystemConfigInfo systemConfigInfo, VWWorkflowDefinition wflDefinition, String theWFDocKey, boolean theLinked, boolean theMakeNewWorkSpace, int productId) throws VWException {
        VWTransferResult result = null;
        try {
            result = this.transfer0(new Integer(logonHandle.getHandle()), logonCredentials, systemConfigInfo, wflDefinition, theWFDocKey, theLinked, theMakeNewWorkSpace, productId);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.transferFailed", "VWServer Exception: {0}");
        }
        return result;
    }

    public VWRosterDefinition getRosterDefinition(VWLogonHandle logonHandle, String rosterName) throws VWException {
        VWRosterDefinition theResults = null;
        try {
            theResults = this.getRosterDefinition0(new Integer(logonHandle.getHandle()), rosterName);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getRosterDefinitionFailed", "VWServer Exception: {0}");
        }
        return theResults;
    }

    public VWQueueDefinition getQueueDefinition(VWLogonHandle logonHandle, String queueName) throws VWException {
        VWQueueDefinition theResults = null;
        try {
            theResults = this.getQueueDefinition0(new Integer(logonHandle.getHandle()), queueName);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getQueueDefinitionFailed", "VWServer Exception: {0}");
        }
        return theResults;
    }

    public VWLogDefinition getLogDefinition(VWLogonHandle logonHandle, String logName) throws VWException {
        VWLogDefinition theResults = null;
        try {
            theResults = this.getLogDefinition0(new Integer(logonHandle.getHandle()), logName);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getLogDefinitionFailed", "VWServer Exception: {0}");
        }
        return theResults;
    }

    public VWQueryResults fetch(VWLogonHandle logonHandle, int viewId, int queryType, int resultType, int maxNumToReturn, String indexName, Object[] minValues, Object[] maxValues, int queryFlags, String preFilterSQL, Object[] substitutionVarNames, VWWorkRecord startRecord, double rpUniqueId, boolean userBoundQuery, String logName) throws VWException {
        VWQueryResults queryResults = null;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("fetch: View id is: " + viewId);
        }
        if ((resultType == 3 || resultType == 4) && (queryFlags & 0x200) == 512) {
            queryFlags |= 0x100;
        }
        try {
            switch (queryType) {
                case 2: {
                    queryResults = this.qDoQuery0(new Integer(logonHandle.getHandle()), viewId, resultType, maxNumToReturn, indexName, minValues, maxValues, queryFlags, preFilterSQL, substitutionVarNames, (VWQueueRecord)startRecord, rpUniqueId, userBoundQuery);
                    break;
                }
                case 1: {
                    queryResults = this.sDoQuery0(new Integer(logonHandle.getHandle()), viewId, resultType, maxNumToReturn, indexName, minValues, maxValues, queryFlags, preFilterSQL, substitutionVarNames, (VWRosterRecord)startRecord, rpUniqueId);
                    break;
                }
                case 3: {
                    queryResults = this.logQuery0(new Integer(logonHandle.getHandle()), maxNumToReturn, indexName, minValues, maxValues, queryFlags, preFilterSQL, substitutionVarNames, (VWLogTableRecord)startRecord, rpUniqueId, logName);
                    break;
                }
                default: {
                    if (this.debugOn) {
                        this.javaSideLogToVWTRACE("Invalid Query Type.");
                    }
                    throw new VWException("vw.server.InvalidQueryType", "VWServer Exception: Invalid Query Type.");
                }
            }
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.QueryFetchFailed", "VWServer Exception: {0}");
        }
        return queryResults;
    }

    public Integer fetchCount(VWLogonHandle logonHandle, int viewId, int queryType, int resultType, String indexName, Object[] minValues, Object[] maxValues, int queryFlags, String preFilterSQL, Object[] substitutionVarNames, boolean userBoundQuery, String logName) throws VWException {
        Integer queryResults = null;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("fetchCount: View id is: " + viewId);
        }
        try {
            switch (queryType) {
                case 2: {
                    queryResults = this.qDoQueryCount0(new Integer(logonHandle.getHandle()), viewId, resultType, indexName, minValues, maxValues, queryFlags, preFilterSQL, substitutionVarNames, userBoundQuery);
                    break;
                }
                case 1: {
                    queryResults = this.sDoQueryCount0(new Integer(logonHandle.getHandle()), viewId, resultType, indexName, minValues, maxValues, queryFlags, preFilterSQL, substitutionVarNames);
                    break;
                }
                case 3: {
                    queryResults = this.logQueryCount0(new Integer(logonHandle.getHandle()), indexName, minValues, maxValues, queryFlags, preFilterSQL, substitutionVarNames, logName);
                    break;
                }
                default: {
                    if (this.debugOn) {
                        this.javaSideLogToVWTRACE("Invalid Query Type.");
                    }
                    throw new VWException("vw.server.InvalidQueryType", "VWServer Exception: Invalid Query Type.");
                }
            }
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.QueryFetchCountFailed", "VWServer Exception: {0}");
        }
        return queryResults;
    }

    public Integer getQueueDepth(VWLogonHandle logonHandle, int viewId, boolean userBoundQueueQuery) throws VWException {
        int queueDepth = 0;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getQueueDepth: View id is: " + viewId);
        }
        try {
            queueDepth = this.getQueueDepth0(new Integer(logonHandle.getHandle()), viewId, userBoundQueueQuery);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetQueueDepthFailed", "VWServer Exception: {0}");
        }
        return new Integer(queueDepth);
    }

    public Boolean getLoggingState(VWLogonHandle logonHandle, int viewId, int loggingOption) throws VWException {
        boolean loggingState = false;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getLoggingState: View id is: " + viewId);
        }
        try {
            loggingState = this.getLoggingState0(new Integer(logonHandle.getHandle()), viewId, loggingOption);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetLoggingStateFailed", "VWServer Exception: {0}");
        }
        return new Boolean(loggingState);
    }

    public void logMessage(VWLogonHandle logonHandle, int viewId, int loggingOption, String message) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("logMessage: View id is: " + viewId);
        }
        try {
            this.logMessage0(new Integer(logonHandle.getHandle()), viewId, loggingOption, message);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.LogMessageFailed", "VWServer Exception: {0}");
        }
    }

    public Object[] getWorkElementFields(VWLogonHandle logonHandle, int viewId, int queryType, VWWorkObjectID[] workObjectIds, int resultType, boolean lock, boolean overrideLock, boolean userBoundQuery, int queryFlags, int thecommand) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getWorkElementFields: Entering getWorkElementFields...");
            this.javaSideLogToVWTRACE("getWorkElementFields: View id is: " + viewId);
        }
        Object[] workElementFields = null;
        String msg = null;
        if ((resultType == 3 || resultType == 4) && (queryFlags & 0x200) == 512) {
            queryFlags |= 0x100;
        }
        int numWorkObjs = workObjectIds.length;
        workElementFields = new Object[workObjectIds.length];
        for (int i = 0; i < numWorkObjs; ++i) {
            try {
                switch (queryType) {
                    case 2: {
                        if (thecommand == 1) {
                            workElementFields[i] = this.queueGetWorkElementFields0(new Integer(logonHandle.getHandle()), viewId, workObjectIds[i], resultType, lock, msg, overrideLock, userBoundQuery, queryFlags);
                            if (workElementFields[i] instanceof VWWorkElementFields) {
                                workObjectIds[i] = ((VWWorkElementFields)workElementFields[i]).workObjectId;
                            }
                        }
                        if (lock) {
                            if (resultType == 1) {
                                workElementFields[i] = this.qLockWorkObject0(new Integer(logonHandle.getHandle()), viewId, workObjectIds[i], msg, overrideLock, queryFlags);
                            }
                            if (resultType != 2 && resultType != 5) break;
                            workElementFields[i] = this.qLockInvocation0(new Integer(logonHandle.getHandle()), viewId, workObjectIds[i], msg, overrideLock, queryFlags);
                            break;
                        }
                        if (thecommand != 0) break;
                        workElementFields[i] = this.queueGetWorkElementFields0(new Integer(logonHandle.getHandle()), viewId, workObjectIds[i], resultType, lock, msg, overrideLock, userBoundQuery, queryFlags);
                        break;
                    }
                    case 1: {
                        if (thecommand == 1) {
                            workElementFields[i] = this.rosterGetWorkElementFields0(new Integer(logonHandle.getHandle()), viewId, workObjectIds[i], resultType, lock, msg, overrideLock, queryFlags);
                            if (workElementFields[i] instanceof VWWorkElementFields) {
                                workObjectIds[i] = ((VWWorkElementFields)workElementFields[i]).workObjectId;
                            }
                        }
                        if (lock) {
                            if (resultType == 1) {
                                workElementFields[i] = this.rLockWorkObject0(new Integer(logonHandle.getHandle()), viewId, workObjectIds[i], msg, overrideLock, queryFlags);
                            }
                            if (resultType != 2 && resultType != 5) break;
                            workElementFields[i] = this.rLockInvocation0(new Integer(logonHandle.getHandle()), viewId, workObjectIds[i], msg, overrideLock, queryFlags);
                            break;
                        }
                        if (thecommand != 0) break;
                        workElementFields[i] = this.rosterGetWorkElementFields0(new Integer(logonHandle.getHandle()), viewId, workObjectIds[i], resultType, lock, msg, overrideLock, queryFlags);
                        break;
                    }
                    default: {
                        if (this.debugOn) {
                            this.javaSideLogToVWTRACE("Invalid Query Type:" + queryType);
                        }
                        throw new VWException("vw.server.InvalidQueryType", "VWServer Exception: Invalid Query Type.");
                    }
                }
                if (workElementFields[i] == null || !(workElementFields[i] instanceof VWException) || !this.debugOn) continue;
                this.javaSideLogToVWTRACE(((VWException)workElementFields[i]).getMessage());
                continue;
            }
            catch (Exception e) {
                this.ThrowVWServerException(e, "vw.server.GetWorkElementFieldsFailed", "VWServer Exception: {0}");
            }
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getWorkElementFields: Exiting getWorkElementFields...");
        }
        return workElementFields;
    }

    public Hashtable getIndexFields(VWLogonHandle logonHandle, String queueName) throws VWException {
        Hashtable indexFields = null;
        try {
            indexFields = this.getIndexFields0(new Integer(logonHandle.getHandle()), queueName);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetIndexFieldsFailed", "VWServer Exception: {0}");
        }
        return indexFields;
    }

    public String[] getExposedFields(VWLogonHandle logonHandle, String queueName) throws VWException {
        String[] exposedFields = null;
        try {
            exposedFields = this.getExposedFields0(new Integer(logonHandle.getHandle()), queueName);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetExposedFieldsFailed", "VWServer Exception: {0}");
        }
        return exposedFields;
    }

    public VWField[] getNewWorkObjectFields(VWLogonHandle logonHandle, String rosterName) throws VWException {
        VWField[] newWorkObjectFields = null;
        if (rosterName == null) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("Roster class name is undefined.");
            }
            throw new VWException("vw.server.UndefinedClass", "VWServer Exception: Roster class name is undefined.");
        }
        try {
            newWorkObjectFields = this.getNewWorkObjectFields0(new Integer(logonHandle.getHandle()), rosterName);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetNewWorkObjectFieldsFailed", "VWServer Exception: {0}");
        }
        return newWorkObjectFields;
    }

    public Object[] terminateWorkObject(VWLogonHandle logonHandle, int viewId, int queryType, VWWorkObjectID[] workObjectIds, boolean throwException, boolean userBoundQuery) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("terminateWorkObject: Entering terminateWorkObject...");
            this.javaSideLogToVWTRACE("terminateWorkObject: View id is: " + viewId);
        }
        Object[] terminateWobStatus = null;
        int numWobs = 0;
        try {
            numWobs = workObjectIds.length;
            terminateWobStatus = new Object[numWobs];
            terminateWobStatus = this.terminateWorkObject0(new Integer(logonHandle.getHandle()), viewId, queryType, workObjectIds, throwException, userBoundQuery);
            for (int i = 0; i < numWobs; ++i) {
                if (terminateWobStatus[i] == null) continue;
                if (terminateWobStatus[i] instanceof VWException && this.debugOn) {
                    this.javaSideLogToVWTRACE(((VWException)terminateWobStatus[i]).getMessage());
                }
                if (!throwException) continue;
                if (this.debugOn) {
                    this.javaSideLogToVWTRACE("Could Not Terminate Work Object");
                }
                this.ThrowVWServerException((Exception)terminateWobStatus[i], "vw.server.CouldNotTerminateWorkObject", "VWServer Exception: {0}");
            }
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.CouldNotTerminateWorkObject(s)", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("terminateWorkObject: Exiting terminateWorkObject...");
        }
        return terminateWobStatus;
    }

    public Object[] deleteWorkObject(VWLogonHandle logonHandle, int viewId, int queryType, VWWorkObjectID[] workObjectIds, boolean overrideLock, boolean force, boolean throwException, boolean userBoundQuery) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("deleteWorkObject: Entering deleteWorkObject...");
            this.javaSideLogToVWTRACE("deleteWorkObject: View id is: " + viewId);
        }
        Object[] deleteWobStatus = null;
        int numWobs = 0;
        try {
            numWobs = workObjectIds.length;
            deleteWobStatus = new Object[numWobs];
            deleteWobStatus = this.deleteWorkObject0(new Integer(logonHandle.getHandle()), viewId, queryType, workObjectIds, overrideLock, force, throwException, userBoundQuery);
            for (int i = 0; i < numWobs; ++i) {
                if (deleteWobStatus[i] == null) continue;
                if (deleteWobStatus[i] instanceof VWException && this.debugOn) {
                    this.javaSideLogToVWTRACE(((VWException)deleteWobStatus[i]).getMessage());
                }
                if (!throwException) continue;
                if (this.debugOn) {
                    this.javaSideLogToVWTRACE("Could Not Delete Work Object");
                }
                this.ThrowVWServerException((Exception)deleteWobStatus[i], "vw.server.CouldNotDeleteWorkObject", "VWServer Exception: {0}");
            }
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.CouldNotDeleteWorkObject(s)", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("deleteWorkObject: Exiting deleteWorkObject...");
        }
        return deleteWobStatus;
    }

    public String[] getRosterNames(VWLogonHandle logonHandle, boolean ignoreSecurity) throws VWException {
        String[] rosterNames = null;
        try {
            rosterNames = this.getRosterNames0(new Integer(logonHandle.getHandle()), ignoreSecurity);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getRosterNamesFailed", "VWServer Exception: {0}");
        }
        return rosterNames;
    }

    public String[] getWorkClassNames(VWLogonHandle logonHandle, boolean ignoreSecurity, String baseWCName) throws VWException {
        String[] workclassNames = null;
        try {
            workclassNames = this.getWorkClassNames0(new Integer(logonHandle.getHandle()), ignoreSecurity, baseWCName);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getWorkClassNamesFailed", "VWServer Exception: {0}");
        }
        return workclassNames;
    }

    public VWAttributeInfo getAttributes(VWLogonHandle logonHandle, int nFlag) throws VWException {
        VWAttributeInfo theAttributes = null;
        try {
            theAttributes = this.getAttributes0(new Integer(logonHandle.getHandle()), nFlag);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getAttributesFailed", "VWServer Exception: {0}");
        }
        return theAttributes;
    }

    public VWProcess getProcess(VWLogonHandle logonHandle, int workSpaceId, int workClassId, String workflowNumber) throws VWException {
        VWProcess theProcess = null;
        try {
            theProcess = this.getProcess0(new Integer(logonHandle.getHandle()), workSpaceId, workClassId, workflowNumber);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getProcessFailed", "VWServer Exception: {0}");
        }
        return theProcess;
    }

    public Integer getRosterCount(VWLogonHandle logonHandle, int viewId) throws VWException {
        int rosterCount = 0;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getRosterCount: View id is: " + viewId);
        }
        Integer handle = new Integer(logonHandle.getHandle());
        try {
            rosterCount = this.getRosterCount0(handle, viewId);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getRosterCountFailed", "VWServer Exception: {0}");
        }
        return new Integer(rosterCount);
    }

    public Boolean inject(VWLogonHandle logonHandle, String rosterName, VWField[][] fieldValues, String[] rosterNames, String sessionName, String transactionName) throws VWException {
        boolean mustRetry = false;
        int iNumWobs = rosterNames.length;
        if (iNumWobs > 100) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("Too many work objects to inject.");
            }
            throw new VWException("vw.server.TooManyWorkObjects", "VWServer Exception: Too many work objects to inject.");
        }
        if (iNumWobs < 1) {
            return Boolean.TRUE;
        }
        if (rosterName == null) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("Roster class name is undefined.");
            }
            throw new VWException("vw.server.UndefinedClass", "VWServer Exception: Roster class name is undefined.");
        }
        try {
            mustRetry = this.inject0(new Integer(logonHandle.getHandle()), rosterName, fieldValues, rosterNames, sessionName, transactionName);
            if (this.debugOn) {
                if (fieldValues == null) {
                    this.javaSideLogToVWTRACE("no fields to inject.");
                } else {
                    this.javaSideLogToVWTRACE("field name-value pairs are:");
                    for (int i = 0; i < fieldValues.length; ++i) {
                        for (int j = 0; j < fieldValues[i].length; ++j) {
                            this.javaSideLogToVWTRACE("name=" + fieldValues[i][j].getName() + "  value=" + fieldValues[i][j].getValue());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.InjectFailed", "VWServer Exception: {0}");
        }
        return new Boolean(mustRetry);
    }

    public VWInjectInfo getInjectSessionInfo(VWLogonHandle logonHandle, String rosterName, String sessionName, boolean nextName) throws VWException {
        VWInjectInfo injectSessionInfo = null;
        if (rosterName == null) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("Roster class name is undefined.");
            }
            throw new VWException("vw.server.UndefinedClass", "VWServer Exception: Roster class name is undefined.");
        }
        try {
            injectSessionInfo = this.getInjectSessionInfo0(new Integer(logonHandle.getHandle()), rosterName, sessionName, nextName);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetInjectSessionInfoFailed", "VWServer Exception: {0}");
        }
        return injectSessionInfo;
    }

    public Boolean deleteInjectSession(VWLogonHandle logonHandle, String rosterName, String sessionName) throws VWException {
        boolean status = false;
        if (rosterName == null) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("Roster class name is undefined.");
            }
            throw new VWException("vw.server.UndefinedClass", "VWServer Exception: Roster class name is undefined.");
        }
        try {
            status = this.deleteInjectSession0(new Integer(logonHandle.getHandle()), rosterName, sessionName);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.DeleteInjectSessionFailed", "VWServer Exception: {0}");
        }
        return new Boolean(status);
    }

    public Object[] getLockStatus(VWLogonHandle logonHandle, int viewId, int queryType, VWWorkObjectID[] workObjectIds, boolean throwException, boolean userBoundQuery) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getLockStatus: Entering getLockStatus...");
            this.javaSideLogToVWTRACE("getLockStatus: View id is: " + viewId);
        }
        Object[] lockStatus = null;
        if (queryType != 1 && queryType != 2) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("VWServer Exception: Invalid query type.");
            }
            throw new VWException("vw.server.InvalidQueryType", "VWServer Exception: Invalid query type.");
        }
        int numWorkObjs = workObjectIds.length;
        lockStatus = new Object[workObjectIds.length];
        for (int i = 0; i < numWorkObjs; ++i) {
            try {
                lockStatus[i] = this.getLockStatus0(new Integer(logonHandle.getHandle()), viewId, queryType, workObjectIds[i], throwException, userBoundQuery);
                if (lockStatus[i] != null && lockStatus[i] instanceof VWException && this.debugOn) {
                    this.javaSideLogToVWTRACE(((VWException)lockStatus[i]).getMessage());
                }
                if (!throwException) continue;
                if (this.debugOn) {
                    this.javaSideLogToVWTRACE("VWServer Exception: Could Not Retrieve Work Object Lock Status.");
                }
                this.ThrowVWServerException((Exception)lockStatus[i], "vw.server.DeleteInjectSessionFailed", "VWServer Exception: {0}");
                continue;
            }
            catch (Exception e) {
                this.ThrowVWServerException(e, "vw.server.GetLockStatusFailed", "VWServer Exception: {0}");
            }
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getLockStatus: Exiting getLockStatus...");
        }
        return lockStatus;
    }

    public Object[] unlockSave(VWLogonHandle logonHandle, int viewId, int queryType, VWWorkObjectID[] workObjectIds, int saveType, VWField[][] fieldValues, boolean bindAll, String userToBind, String exception, String exceptionDescription, boolean isExceptionMap, boolean unlockAll, boolean dispatchAll, boolean throwException, boolean userBoundQuery) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("unlockSave: Entering unlockSave...");
            this.javaSideLogToVWTRACE("unlockSave: View id is: " + viewId);
        }
        Object[] wObjLockStatus = null;
        if (logonHandle == null) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("VWServer Exception: Missing Logon Handle.");
            }
            throw new VWException("vw.server.MissingLogonHandle", "VWServer Exception: Missing Logon Handle.");
        }
        if (dispatchAll && !unlockAll) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("VWServer Exception: Dispatch is not allowed without unlock.");
            }
            throw new VWException("vw.server.DispatchIsNotAllowedWithoutUnlock", "VWServer Exception: Dispatch is not allowed without unlock.");
        }
        if (saveType < 0 || saveType > 3) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("VWServer Exception: Invalid save type.");
            }
            throw new VWException("vw.server.InvalidSaveType", "VWServer Exception: Invalid save type.");
        }
        if (saveType == 0 && dispatchAll) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("VWServer Exception: Dispatch is not allowed without save.");
            }
            throw new VWException("vw.server.DispatchIsNotAllowedWithoutSave", "VWServer Exception: Dispatch is not allowed without save.");
        }
        int numWorkObjs = workObjectIds.length;
        wObjLockStatus = new Object[workObjectIds.length];
        for (int i = 0; i < numWorkObjs; ++i) {
            try {
                wObjLockStatus[i] = saveType == 0 && fieldValues == null ? this.unlockSave0(new Integer(logonHandle.getHandle()), viewId, queryType, workObjectIds[i], saveType, null, exception, exceptionDescription, isExceptionMap, unlockAll, dispatchAll, throwException, userBoundQuery) : this.unlockSave0(new Integer(logonHandle.getHandle()), viewId, queryType, workObjectIds[i], saveType, fieldValues[i], exception, exceptionDescription, isExceptionMap, unlockAll, dispatchAll, throwException, userBoundQuery);
                if (throwException) {
                    if (this.debugOn) {
                        this.javaSideLogToVWTRACE("VWServer Exception: Could Not Unlock Work Object.");
                    }
                    this.ThrowVWServerException((Exception)wObjLockStatus[i], "vw.server.CouldNotUnLockSaveWorkObject", "VWServer Exception: {0}");
                }
                if (wObjLockStatus[i] == null || !(wObjLockStatus[i] instanceof VWException) || !this.debugOn) continue;
                this.javaSideLogToVWTRACE(((VWException)wObjLockStatus[i]).getMessage());
                continue;
            }
            catch (Exception e) {
                this.ThrowVWServerException(e, "vw.server.CouldNotUnlockSaveWorkObject", "VWServer Exception: {0}");
            }
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("unlockSave: Exiting unlockSave...");
        }
        return wObjLockStatus;
    }

    public void doReject(VWLogonHandle logonHandle, int viewId, int queryType, VWWorkObjectID workObjectId, int saveType) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("doReject: Entering doReject...");
            this.javaSideLogToVWTRACE("doReject: View id is: " + viewId);
        }
        if (queryType == 1) {
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("VWServer Exception: Invalid operation on a roster.");
            }
            throw new VWException("vw.server.InvalidOperationOnRoster", "VWServer Exception: Invalid operation on a roster.");
        }
        try {
            this.doReject0(new Integer(logonHandle.getHandle()), viewId, workObjectId, saveType);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.doRejectFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("doReject: Exiting doReject...");
        }
    }

    public void doReassign(VWLogonHandle logonHandle, int viewId, int queryType, VWWorkObjectID workObjectId, int saveType, String domainName, String participantName, boolean delegateFlag, String queueName, VWField[] fieldValues, String exception, String exceptionDescription, boolean isExceptionMap, boolean throwException, boolean userBoundQuery, long argFlag) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("doReassign: Entering doReassign... " + delegateFlag);
        }
        try {
            if (delegateFlag) {
                this.doSaveandRedirect0(new Integer(logonHandle.getHandle()), viewId, queryType, workObjectId, saveType, fieldValues, exception, exceptionDescription, isExceptionMap, throwException, userBoundQuery, 4, domainName, participantName, queueName, argFlag);
            } else {
                this.doSaveandRedirect0(new Integer(logonHandle.getHandle()), viewId, queryType, workObjectId, saveType, fieldValues, exception, exceptionDescription, isExceptionMap, throwException, userBoundQuery, 2, domainName, participantName, queueName, argFlag);
            }
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.doReassignFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("doReassign: Exiting doReassign...");
        }
    }

    public void doReturn(VWLogonHandle logonHandle, int viewId, int queryType, VWWorkObjectID workObjectId, int saveType, VWField[] fieldValues, String exception, String exceptionDescription, boolean isExceptionMap, boolean throwException, boolean userBoundQuery) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("doReturn: Entering doReturn...");
            this.javaSideLogToVWTRACE("doReturn: View id is: " + viewId);
        }
        try {
            this.doSaveandRedirect0(new Integer(logonHandle.getHandle()), viewId, queryType, workObjectId, saveType, fieldValues, exception, exceptionDescription, isExceptionMap, throwException, userBoundQuery, 1, null, null, null, 0L);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.doReturnFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("doReturn: Exiting doReturn...");
        }
    }

    public VWField[] getNewStepElement(VWLogonHandle logonHandle, String workClassName) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getNewStepElement: Entering getNewStepElement...");
            this.javaSideLogToVWTRACE("getNewStepElement: WorkClassName: " + workClassName);
        }
        VWField[] result = null;
        try {
            result = this.getNewStepElement0(new Integer(logonHandle.getHandle()), workClassName);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getNewStepElement", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getNewStepElement: Exiting getNewStepElement...");
        }
        return result;
    }

    public Object[] saveNewStepElement(VWLogonHandle logonHandle, VWField[] fieldValues, String workClassName, int workSpaceId) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("saveNewStepElement: Entering saveNewStepElement...");
            this.javaSideLogToVWTRACE("saveNewStepElement: WorkClassName: " + workClassName + " WS:" + workSpaceId);
        }
        Object[] result = null;
        try {
            result = this.saveNewStepElement0(new Integer(logonHandle.getHandle()), fieldValues, workClassName, workSpaceId);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.saveNewStepElement", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("saveNewStepElement: Exiting saveNewStepElement...");
        }
        return result;
    }

    public VWField[] getNewStepFromVWVersion(VWLogonHandle logonHandle, String vwversion) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getNewStepFromVWVersion: Entering getNewStepFromVWVersion...");
            this.javaSideLogToVWTRACE("getNewStepFromVWVersion: vwversion: " + vwversion);
        }
        VWField[] result = null;
        try {
            result = this.getNewStepFromVWVersion0(new Integer(logonHandle.getHandle()), vwversion);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getNewStepFromVWVersion", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getNewStepElement: Exiting getNewStepFromVWVersion...");
        }
        return result;
    }

    public Boolean checkVWVersion(VWLogonHandle logonHandle, String vwversion) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("checkVWVersion: Entering getNewStepElement...");
            this.javaSideLogToVWTRACE("checkVWVersion: : " + vwversion);
        }
        boolean result = false;
        try {
            result = this.checkVWVersion0(new Integer(logonHandle.getHandle()), vwversion);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.checkVWVersion", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("checkVWVersion: Exiting checkVWVersion...");
        }
        return new Boolean(result);
    }

    public VWQueueStats getQueueStatistics(VWLogonHandle logonHandle, int viewId, Date startTime, Date endTime, int timeUnits) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getQueueStatistics: Entering getQueueStatistics...");
        }
        VWQueueStats theStats = null;
        try {
            theStats = this.getQueueStatistics0(new Integer(logonHandle.getHandle()), viewId, startTime, endTime, timeUnits);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getQueueStatisticsFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getQueueStatistics: Exiting getQueueStatistics...");
        }
        return theStats;
    }

    public VWRosterStats getRosterStatistics(VWLogonHandle logonHandle, int viewId, Date startTime, Date endTime, int timeUnits) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getRosterStatistics: Entering getRosterStatistics...");
        }
        VWRosterStats theStats = null;
        try {
            theStats = this.getRosterStatistics0(new Integer(logonHandle.getHandle()), viewId, startTime, endTime, timeUnits);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getRosterStatisticsFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getRosterStatistics: Exiting getRosterStatistics...");
        }
        return theStats;
    }

    public Boolean isMemberOfGroup(VWLogonHandle logonHandle, String groupName, String domainName, long rpcArgFlag) throws VWException {
        boolean isMemberOfGroup = false;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("isMemberOfGroup: Entering isMemberOfGroup...");
        }
        try {
            isMemberOfGroup = this.isMemberOfGroup0(new Integer(logonHandle.getHandle()), groupName, domainName, rpcArgFlag);
        }
        catch (Exception e) {
            String theKey;
            if (this.debugOn) {
                VWServer.dumpExceptionStack(e);
            }
            if (e instanceof VWException && (theKey = ((VWException)e).getKey()).compareTo("vw.server.InvalidGroupName") == 0) {
                throw new VWException("vw.server.InvalidGroupName", "VWServer Exception: Invalid group name passed in.");
            }
            this.ThrowVWServerException(e, "vw.server.IsMemberOfGroupFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("isMemberOfGroup: Exiting isMemberOfGroup...");
        }
        return new Boolean(isMemberOfGroup);
    }

    public Boolean[] fetchIsGroup(VWLogonHandle logonHandle, String[] names) throws VWException {
        Boolean[] isGroup = null;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("fetchIsGroup: Entering FetchIsGroup...");
        }
        try {
            isGroup = this.fetchIsGroup0(new Integer(logonHandle.getHandle()), names);
        }
        catch (Exception e) {
            if (this.debugOn) {
                VWServer.dumpExceptionStack(e);
            }
            this.ThrowVWServerException(e, "vw.server.fetchIsGroup", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("fetchIsGroup: Exiting fetchIsGroup...");
        }
        return isGroup;
    }

    public Boolean[] fetchAttachmentIsReferenced(VWLogonHandle logonHandle, VWAttachment[] theAttachments) throws VWException {
        Boolean[] attachmentIsReferenced = null;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("");
        }
        try {
            attachmentIsReferenced = this.fetchAttachmentIsReferenced0(new Integer(logonHandle.getHandle()), theAttachments);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.fetchAttachmentIsReferenced", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("fetchAttachmentIsReferenced: Exiting fetchAttachmentIsReferenced...");
        }
        return attachmentIsReferenced;
    }

    public VWQueryResults fetchAttachmentIsReferencedBy(VWLogonHandle logonHandle, VWAttachment theAttachment, int theLimit, int workClassId, String wobNum) throws VWException {
        VWQueryResults fromServer = null;
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("fetchAttachmentIsReferencedBy: Entering fetchAttachmentIsReferencedBy...");
        }
        try {
            fromServer = this.fetchAttachmentIsReferencedBy0(new Integer(logonHandle.getHandle()), theAttachment, theLimit, workClassId, wobNum);
            if (this.debugOn) {
                this.javaSideLogToVWTRACE("returned from call... fields array size is " + fromServer.fieldValues.length);
            }
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.fetchAttachmentIsReferencedBy", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("fetchAttachmentIsReferencedBy: Exiting fetchAttachmentIsReferencedBy...");
        }
        return fromServer;
    }

    public void removeLinkFlag(VWLogonHandle logonHandle, String theDocument) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("removeLinkFlag: Entering removeLinkFlag...");
        }
        try {
            this.removeLinkFlag0(new Integer(logonHandle.getHandle()), theDocument);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.removeLinkFlagFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("removeLinkFlag: Exiting removeLinkFlag...");
        }
    }

    public VWStepProcessorInfo[] getStepProcessorList(VWLogonHandle logonHandle, int processorType, int productId) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getStepProcessorInfo: Entering getStepProcessorList...");
        }
        VWStepProcessorInfo[] stepProcessorInfo = null;
        try {
            stepProcessorInfo = this.getStepProcessorList0(new Integer(logonHandle.getHandle()), processorType, productId);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetStepProcessorListFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            if (stepProcessorInfo != null) {
                this.javaSideLogToVWTRACE("getStepProcessorInfo: Exiting getStepProcessorList..." + stepProcessorInfo.length);
            } else {
                this.javaSideLogToVWTRACE("getStepProcessorInfo: Exiting getStepProcessorList... NULL");
            }
        }
        return stepProcessorInfo;
    }

    public VWStepProcessorInfo getLaunchStepProcessor(VWLogonHandle logonHandle, String processorIdentifier, int productId) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getLaunchStepProcessor: Entering getLaunchStepProcessor...");
        }
        VWStepProcessorInfo stepProcessorInfo = null;
        try {
            stepProcessorInfo = this.getLaunchStepProcessor0(new Integer(logonHandle.getHandle()), processorIdentifier, productId);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetLaunchStepProcessorFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getLaunchStepProcessor: Exiting getLaunchStepProcessor...");
        }
        return stepProcessorInfo;
    }

    public VWStepProcessorInfo getStepProcessorByName(VWLogonHandle logonHandle, String processorName, int productId) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getStepProcessorByName: Entering getStepProcessorByName...");
        }
        VWStepProcessorInfo stepProcessorInfo = null;
        try {
            stepProcessorInfo = this.getStepProcessorByName0(new Integer(logonHandle.getHandle()), processorName, productId);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetStepProcessorByNameFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getStepProcessorByName: Exiting getStepProcessorByName...");
        }
        return stepProcessorInfo;
    }

    public VWStepProcessorInfo getStepProcessorById(VWLogonHandle logonHandle, int processorID, int productId) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getStepProcessorById: Entering getStepProcessorById...");
        }
        VWStepProcessorInfo stepProcessorInfo = null;
        try {
            stepProcessorInfo = this.getStepProcessorById0(new Integer(logonHandle.getHandle()), processorID, productId);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetStepProcessorByIdFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getStepProcessorById: Exiting getStepProcessorById...");
        }
        return stepProcessorInfo;
    }

    public VWCreateLiveWOResult[] createLiveWorkObject(VWLogonHandle logonHandle, VWField[] fieldValues, String workflowIdentifier, int numberToCreate) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("createLiveWorkObject: Entering createLiveWorkObject...workflowIdentifier=" + workflowIdentifier);
        }
        int index = -1;
        VWCreateLiveWOResult[] results = null;
        try {
            if (numberToCreate < 1) {
                results = new VWCreateLiveWOResult[]{null};
                throw new VWException("vw.server.VWCreateLiveWOResultBadRequest:", "VWServer Exception: Request to create less than one work object is invalid.");
            }
            results = new VWCreateLiveWOResult[numberToCreate];
            for (index = 0; index < numberToCreate; ++index) {
                if (this.debugOn) {
                    if (fieldValues == null) {
                        this.javaSideLogToVWTRACE("no fields to update.");
                    } else {
                        this.javaSideLogToVWTRACE("field name-value pairs are:");
                        for (int i = 0; i < fieldValues.length; ++i) {
                            this.javaSideLogToVWTRACE("name=" + fieldValues[i].getName() + "  value=" + fieldValues[i].getValue());
                        }
                    }
                }
                results[index] = this.createLiveWorkObject0(new Integer(logonHandle.getHandle()), fieldValues, workflowIdentifier);
                if (results[index].success()) continue;
                throw new VWException("vw.server.createLiveWorkObjectIndex", "VWServer Exception: could not create workobject for element {0}", index);
            }
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.createLiveWorkObject:", "VWServer Exception: number=" + index + " create failed with: " + "{0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("createLiveWorkObject: Exiting createLiveWorkObject...");
        }
        return results;
    }

    public String getWorkClassXML(VWLogonHandle logonHandle, int workSpaceId, String workflowIdentifier, boolean bAuthorForm, boolean bConvert) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getWorkClassXML: Entering getWorkClassXML...");
        }
        String xmlString = null;
        try {
            xmlString = this.getWorkClassXML0(new Integer(logonHandle.getHandle()), workSpaceId, workflowIdentifier, bAuthorForm, bConvert);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetWorkClassXMLFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getWorkClassXML: Exiting getWorkClassXML...");
        }
        return xmlString;
    }

    protected void ThrowVWServerException(Exception e, String excKey, String excDesc) throws VWException {
        try {
            if (this.debugOn) {
                VWServer.dumpExceptionStack(e);
            }
            if (e instanceof VWQueueMovedException) {
                throw (VWQueueMovedException)e;
            }
            if (e instanceof VWStaleLogonException) {
                throw (VWStaleLogonException)e;
            }
            if (e instanceof VWOpNotAllowedException) {
                throw (VWOpNotAllowedException)e;
            }
            if (e instanceof VWWorkSpaceTimeStampStaleException) {
                throw (VWWorkSpaceTimeStampStaleException)e;
            }
            if (e instanceof VWViewDoesNotExistException) {
                throw (VWViewDoesNotExistException)e;
            }
            if (e instanceof VWNoOnlineClassesException) {
                throw (VWNoOnlineClassesException)e;
            }
            throw new VWException(excKey, excDesc, e.getMessage());
        }
        catch (Exception exc) {
            if (this.debugOn) {
                VWServer.dumpExceptionStack(exc);
            }
            this.javaSideLogToVWTRACE(exc.getMessage());
            if (exc instanceof VWException) {
                throw (VWException)exc;
            }
            throw new VWException(excKey, excDesc, exc.getMessage());
        }
    }

    public VWWorkflowSignature getWorkflowSignature(VWLogonHandle logonHandle, String workflowIdentifier) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getWorkflowSignature: Entering getWorkflowSignature...logonHandle=" + logonHandle.getHandle() + "workflowIdentifier=" + workflowIdentifier);
        }
        VWWorkflowSignature workflowSig = null;
        try {
            workflowSig = this.getWorkflowSignature0(new Integer(logonHandle.getHandle()), workflowIdentifier);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getWorkflowSignature", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getWorkflowSignature: Exiting getWorkflowIdentifier...");
        }
        return workflowSig;
    }

    public String getFileFromServer(VWLogonHandle logonHandle, String fileName, int fileType) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getFileFromServer: Entering getFileFromServer...logonHandle=" + logonHandle.getHandle() + " FileName=" + fileName);
        }
        String fileContents = null;
        try {
            fileContents = this.getFileFromServer0(new Integer(logonHandle.getHandle()), fileName, fileType);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getFileFromServer", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getFileFromServer: Exiting getFileFromServer...");
        }
        return fileContents;
    }

    public Boolean getLimitApplicationFunctionalityFlag(VWLogonHandle logonHandle) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getLimitApplicationFunctionalityFlag: Entering getLimitApplicationFunctionalityFlag...logonHandle=" + logonHandle.getHandle());
        }
        boolean limitAppsFlag = false;
        try {
            limitAppsFlag = this.getLimitApplicationFunctionalityFlag0(new Integer(logonHandle.getHandle()));
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.getLimitApplicationFunctionalityFlag", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getLimitApplicationFunctionalityFlag: Exiting getLimitApplicationFunctionalityFlag...");
        }
        return new Boolean(limitAppsFlag);
    }

    public VWReturnStackElement[] getReturnStackElements(VWLogonHandle logonHandle, int viewId, int queryType, VWWorkObjectID workObjectId, boolean userBoundQuery) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getReturnStackElements: Entering getRetrunStackElements...");
            this.javaSideLogToVWTRACE("getReturnStackElements: View id is: " + viewId);
        }
        VWReturnStackElement[] returnStackElements = null;
        Object msg = null;
        try {
            switch (queryType) {
                case 2: {
                    returnStackElements = this.queueGetReturnStackElements0(new Integer(logonHandle.getHandle()), viewId, workObjectId, userBoundQuery);
                    break;
                }
                case 1: {
                    returnStackElements = this.rosterGetReturnStackElements0(new Integer(logonHandle.getHandle()), viewId, workObjectId);
                    break;
                }
                default: {
                    if (this.debugOn) {
                        this.javaSideLogToVWTRACE("Invalid Query Type:" + queryType);
                    }
                    throw new VWException("vw.server.InvalidQueryType", "VWServer Exception: Invalid Query Type.");
                }
            }
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.GetReturnStackElementsFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("getReturnStackElements: Exiting getWorkElementFields...");
        }
        return returnStackElements;
    }

    public VWParticipant[] convertSecurityIdstoNames(VWLogonHandle logonHandle, Long[] ids) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("convertSecurityIdstoNames: Entering convertSecurityIdstoNames...");
        }
        VWParticipant[] oParticipants = null;
        try {
            oParticipants = this.convertSecurityIdstoNames0(new Integer(logonHandle.getHandle()), ids);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.ConvertSecurityIdstoNamesFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("convertSecurityIdstoNames: Exiting convertSecurityIdstoNames...");
        }
        return oParticipants;
    }

    public Long[] convertSecurityNamestoIds(VWLogonHandle logonHandle, String[] names, boolean assignId) throws VWException {
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("convertSecurityNamestoIds: Entering convertSecurityNamestoIds...");
        }
        Long[] ids = null;
        try {
            ids = this.convertSecurityNamestoIds0(new Integer(logonHandle.getHandle()), names, assignId);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.ConvertSecurityNamestoIdsFailed", "VWServer Exception: {0}");
        }
        if (this.debugOn) {
            this.javaSideLogToVWTRACE("convertSecurityNamestoIds: Exiting convertSecurityNamestoIds...");
        }
        return ids;
    }

    public VWEnvironmentDataQueryResults fetchUserEnvironmentRecords(VWLogonHandle logonHandle, int maxBufferSize, VWEnvironmentData startRecord, boolean throwException) throws VWException {
        VWEnvironmentDataQueryResults theValues = null;
        try {
            theValues = this.fetchUserEnvironmentRecords0(new Integer(logonHandle.getHandle()), maxBufferSize, startRecord, throwException);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.fetchUserEnvironmentRecordsFailed", "VWServer Exception: {0}");
        }
        return theValues;
    }

    public VWSecurityDomain[] fetchSecurityDomains(VWLogonHandle logonHandle) throws VWException {
        VWSecurityDomain[] arrayOfSecDomain = null;
        try {
            arrayOfSecDomain = this.fetchSecurityDomains0(new Integer(logonHandle.getHandle()));
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.fetchSecurityDomainsFailed", "VWServer Exception: {0}");
        }
        return arrayOfSecDomain;
    }

    public VWParticipant[] fetchParticipants(VWLogonHandle logonHandle, String domainName, String[] theUserNameList, long rpcArgFlag) throws VWException {
        VWParticipant[] arrayOfVWParticipant = null;
        try {
            arrayOfVWParticipant = this.fetchParticipants0(new Integer(logonHandle.getHandle()), domainName, theUserNameList, rpcArgFlag);
        }
        catch (Exception e) {
            this.ThrowVWServerException(e, "vw.server.fetchParticipantsFailed", "VWServer Exception: {0}");
        }
        return arrayOfVWParticipant;
    }

    private native String readJavaVersion() throws Exception;

    private native void messageToLog(boolean var1, int var2, String var3) throws Exception;

    private native void libInit(boolean var1) throws Exception;

    private native void libExit();

    private native VWLogonResult rootLogon0(Integer var1, String var2, String var3, String var4, long var5) throws Exception;

    private native VWLogonHandle logon0(Integer var1, String var2, String var3, String var4, long var5, long var7, long var9) throws Exception;

    private native void logoff0(Integer var1, VWConfigInfo[] var2) throws Exception;

    private native VWConfigResult getConfigInfo0(Integer var1) throws Exception;

    private native Hashtable getAllServers0(Integer var1) throws Exception;

    private native Hashtable getUserNames0(Integer var1) throws Exception;

    private native VWSecurityQueryResults fetchUserList0(Integer var1, int var2, int var3, String var4, String var5, String var6, int var7, int var8, long var9) throws Exception;

    private native boolean recoverUser0(Integer var1, String var2, String[] var3) throws Exception;

    private native String[] getQueueNames0(Integer var1, boolean var2, boolean var3) throws Exception;

    private native String[] getQueueOperations0(Integer var1, String var2) throws Exception;

    private native String[] getLogNames0(Integer var1) throws Exception;

    private native String getCurrentVersion0(Integer var1) throws Exception;

    private native VWQueryResults logQuery0(Integer var1, int var2, String var3, Object[] var4, Object[] var5, int var6, String var7, Object[] var8, VWLogTableRecord var9, double var10, String var12) throws Exception;

    private native void initializeAllRegions0(Integer var1) throws Exception;

    private native void initializeRegion0(Integer var1, boolean var2, int var3) throws Exception;

    private native void removeDatabase0(Integer var1) throws Exception;

    private native void setSystemWideConfig0(Integer var1, VWSystemWideInfo var2) throws Exception;

    private native VWSystemWideInfo getSystemWideConfig0(Integer var1) throws Exception;

    private native Hashtable fetchServerConfiguration0(Integer var1, String[] var2) throws Exception;

    private native VWEnvironmentData[] fetchUserInfo0(Integer var1, String[] var2) throws Exception;

    private native void saveUserInfo0(Integer var1, VWEnvironmentData var2) throws Exception;

    private native void deleteUserInfo0(Integer var1, String var2) throws Exception;

    private native VWSystemConfigInfo getSystemConfigInfo0(Integer var1, int var2) throws Exception;

    private native VWTransferResult transfer0(Integer var1, VWLogonCredentials var2, VWSystemConfigInfo var3, VWWorkflowDefinition var4, String var5, boolean var6, boolean var7, int var8) throws Exception;

    private native VWQueueDefinition getQueueDefinition0(Integer var1, String var2) throws Exception;

    private native VWLogDefinition getLogDefinition0(Integer var1, String var2) throws Exception;

    private native boolean isMemberOfGroup0(Integer var1, String var2, String var3, long var4) throws Exception;

    private native Boolean[] fetchIsGroup0(Integer var1, String[] var2) throws Exception;

    private native void removeLinkFlag0(Integer var1, String var2) throws Exception;

    private native VWStepProcessorInfo[] getStepProcessorList0(Integer var1, int var2, int var3) throws Exception;

    private native VWStepProcessorInfo getLaunchStepProcessor0(Integer var1, String var2, int var3) throws Exception;

    private native VWStepProcessorInfo getStepProcessorByName0(Integer var1, String var2, int var3) throws Exception;

    private native VWStepProcessorInfo getStepProcessorById0(Integer var1, int var2, int var3) throws Exception;

    private native Integer logQueryCount0(Integer var1, String var2, Object[] var3, Object[] var4, int var5, String var6, Object[] var7, String var8) throws Exception;

    private native VWCreateLiveWOResult createLiveWorkObject0(Integer var1, VWField[] var2, String var3) throws Exception;

    private native VWWorkflowSignature getWorkflowSignature0(Integer var1, String var2) throws Exception;

    private native String getFileFromServer0(Integer var1, String var2, int var3) throws Exception;

    private native boolean getLimitApplicationFunctionalityFlag0(Integer var1) throws Exception;

    private native String getWorkClassXML0(Integer var1, int var2, String var3, boolean var4, boolean var5) throws Exception;

    private native VWParticipant[] convertSecurityIdstoNames0(Integer var1, Long[] var2) throws VWException;

    private native Long[] convertSecurityNamestoIds0(Integer var1, String[] var2, boolean var3) throws VWException;

    private native VWEnvironmentDataQueryResults fetchUserEnvironmentRecords0(Integer var1, int var2, VWEnvironmentData var3, boolean var4) throws Exception;

    private native VWSecurityDomain[] fetchSecurityDomains0(Integer var1) throws Exception;

    private native VWParticipant[] fetchParticipants0(Integer var1, String var2, String[] var3, long var4) throws Exception;

    private native VWQueryResults qDoQuery0(Integer var1, int var2, int var3, int var4, String var5, Object[] var6, Object[] var7, int var8, String var9, Object[] var10, VWQueueRecord var11, double var12, boolean var14) throws Exception;

    private native int getQueueDepth0(Integer var1, int var2, boolean var3) throws Exception;

    private native boolean getLoggingState0(Integer var1, int var2, int var3) throws Exception;

    private native void logMessage0(Integer var1, int var2, int var3, String var4) throws Exception;

    private native Object qLockWorkObject0(Integer var1, int var2, VWWorkObjectID var3, String var4, boolean var5, int var6) throws Exception;

    private native Object qLockInvocation0(Integer var1, int var2, VWWorkObjectID var3, String var4, boolean var5, int var6) throws Exception;

    private native Object queueGetWorkElementFields0(Integer var1, int var2, VWWorkObjectID var3, int var4, boolean var5, String var6, boolean var7, boolean var8, int var9) throws Exception;

    private native Hashtable getIndexFields0(Integer var1, String var2) throws Exception;

    private native String[] getExposedFields0(Integer var1, String var2) throws Exception;

    private native VWField[] getNewWorkObjectFields0(Integer var1, String var2) throws Exception;

    private native Object[] terminateWorkObject0(Integer var1, int var2, int var3, VWWorkObjectID[] var4, boolean var5, boolean var6) throws Exception;

    private native Object[] deleteWorkObject0(Integer var1, int var2, int var3, VWWorkObjectID[] var4, boolean var5, boolean var6, boolean var7, boolean var8) throws Exception;

    private native void doReject0(Integer var1, int var2, VWWorkObjectID var3, int var4) throws Exception;

    private native void doSaveandRedirect0(Integer var1, int var2, int var3, VWWorkObjectID var4, int var5, VWField[] var6, String var7, String var8, boolean var9, boolean var10, boolean var11, int var12, String var13, String var14, String var15, long var16) throws Exception;

    public native VWQueueStats getQueueStatistics0(Integer var1, int var2, Date var3, Date var4, int var5) throws VWException;

    private native Integer qDoQueryCount0(Integer var1, int var2, int var3, String var4, Object[] var5, Object[] var6, int var7, String var8, Object[] var9, boolean var10) throws Exception;

    private native VWReturnStackElement[] queueGetReturnStackElements0(Integer var1, int var2, VWWorkObjectID var3, boolean var4) throws Exception;

    private native Boolean[] fetchAttachmentIsReferenced0(Integer var1, VWAttachment[] var2) throws Exception;

    private native VWQueryResults fetchAttachmentIsReferencedBy0(Integer var1, VWAttachment var2, int var3, int var4, String var5) throws Exception;

    private native String[] getRosterNames0(Integer var1, boolean var2) throws Exception;

    private native String[] getWorkClassNames0(Integer var1, boolean var2, String var3) throws Exception;

    private native VWAttributeInfo getAttributes0(Integer var1, int var2) throws Exception;

    private native VWProcess getProcess0(Integer var1, int var2, int var3, String var4) throws Exception;

    private native int getRosterCount0(Integer var1, int var2) throws Exception;

    private native boolean inject0(Integer var1, String var2, VWField[][] var3, String[] var4, String var5, String var6) throws Exception;

    private native VWInjectInfo getInjectSessionInfo0(Integer var1, String var2, String var3, boolean var4) throws Exception;

    private native boolean deleteInjectSession0(Integer var1, String var2, String var3) throws Exception;

    private native VWQueryResults sDoQuery0(Integer var1, int var2, int var3, int var4, String var5, Object[] var6, Object[] var7, int var8, String var9, Object[] var10, VWRosterRecord var11, double var12) throws Exception;

    private native Object rLockWorkObject0(Integer var1, int var2, VWWorkObjectID var3, String var4, boolean var5, int var6) throws Exception;

    private native Object rLockInvocation0(Integer var1, int var2, VWWorkObjectID var3, String var4, boolean var5, int var6) throws Exception;

    private native Object rosterGetWorkElementFields0(Integer var1, int var2, VWWorkObjectID var3, int var4, boolean var5, String var6, boolean var7, int var8) throws Exception;

    public native VWRosterStats getRosterStatistics0(Integer var1, int var2, Date var3, Date var4, int var5) throws VWException;

    private native VWRosterDefinition getRosterDefinition0(Integer var1, String var2) throws Exception;

    private native VWField[] getNewStepElement0(Integer var1, String var2) throws Exception;

    private native Object[] saveNewStepElement0(Integer var1, VWField[] var2, String var3, int var4) throws Exception;

    private native VWField[] getNewStepFromVWVersion0(Integer var1, String var2) throws Exception;

    private native boolean checkVWVersion0(Integer var1, String var2) throws Exception;

    private native Integer sDoQueryCount0(Integer var1, int var2, int var3, String var4, Object[] var5, Object[] var6, int var7, String var8, Object[] var9) throws Exception;

    private native VWReturnStackElement[] rosterGetReturnStackElements0(Integer var1, int var2, VWWorkObjectID var3) throws Exception;

    private native Object getLockStatus0(Integer var1, int var2, int var3, VWWorkObjectID var4, boolean var5, boolean var6) throws Exception;

    private native Object unlockSave0(Integer var1, int var2, int var3, VWWorkObjectID var4, int var5, VWField[] var6, String var7, String var8, boolean var9, boolean var10, boolean var11, boolean var12, boolean var13) throws Exception;

    public static void main(String[] args) {
        boolean bDebugOn = false;
        int svrId = -1;
        int portNumber = -1;
        String traceDirNameArg = "";
        String registryKeyArg = null;
        Registry serverRegistry = null;
        VWServer serverObj = null;
        try {
            for (int iArg = 0; iArg < args.length; ++iArg) {
                String lowerArgStr = args[iArg].toLowerCase(Locale.ENGLISH);
                if (lowerArgStr.equals("-debug")) {
                    bDebugOn = true;
                    continue;
                }
                if (lowerArgStr.startsWith("-t")) {
                    if (args[iArg].length() <= 2) continue;
                    traceDirNameArg = args[iArg].substring(2);
                    continue;
                }
                if (lowerArgStr.startsWith(FNVW_prefix)) {
                    int i = lowerArgStr.lastIndexOf(46);
                    svrId = Integer.valueOf(lowerArgStr.substring(i + 1));
                    registryKeyArg = args[iArg];
                    continue;
                }
                int intVal = -1;
                try {
                    intVal = Integer.parseInt(lowerArgStr);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (intVal == -1) continue;
                if (svrId == -1) {
                    svrId = intVal;
                    continue;
                }
                portNumber = intVal;
            }
            if (svrId == -1) {
                StringBuffer sBuf = new StringBuffer();
                for (int i = 0; i < args.length; ++i) {
                    sBuf.append(args[i]).append("  ");
                }
                VWServer.writeMessageToExceptionFile("Failed to find the server ID in the command line arguments : \n" + sBuf.toString() + "\n" + VWServer.usage().toString() + "\n\n");
                serverObj.libExit();
                System.exit(1);
            }
            serverObj = new VWServer(bDebugOn, svrId, traceDirNameArg);
            if (bDebugOn) {
                serverObj.javaSideLogToVWTRACE("Server ID " + svrId + ": " + "VWServer Constructed, about to bind to registry");
            }
            serverRegistry = portNumber == -1 ? LocateRegistry.getRegistry() : LocateRegistry.getRegistry(portNumber);
            serverRegistry.rebind(registryKeyArg, serverObj);
            if (bDebugOn) {
                VWString msg = new VWString("vw.server.BoundInRegistryPort", "{0} bound in registry port: {1}.", registryKeyArg, portNumber == -1 ? "default(1099)" : String.valueOf(portNumber));
                serverObj.javaSideLogToVWTRACE("Server ID " + svrId + ": " + msg.toString());
            }
            serverObj.performCommand(registryKeyArg, serverObj, serverRegistry);
            serverObj.libExit();
            serverObj = null;
            System.runFinalization();
            System.gc();
            System.exit(0);
        }
        catch (Exception e) {
            if (serverObj != null) {
                VWServer.writeMessageToExceptionFile(e.getMessage());
                if (bDebugOn) {
                    VWServer.dumpExceptionStack(e);
                }
            }
            if (e instanceof ArrayIndexOutOfBoundsException) {
                VWString strMsg = VWServer.usage();
                VWServer.writeMessageToExceptionFile(strMsg.toString());
            }
            System.exit(1);
        }
    }

    protected static VWString usage() {
        return new VWString("vw.server.Usage", "Usage: VWServer [-debug] servername [portnumber] [-t<trace_file_directory_name>]");
    }

    private synchronized void javaSideLogToVWTRACE(String message) {
        if (!this.debugOn) {
            return;
        }
        if (this.bVWJAVA_loaded) {
            try {
                String txt = "JNI VWServer, server ID " + this.serverId + " : " + message;
                this.messageToLog(this.toFNSysLog, Info, txt);
            }
            catch (Exception e) {
                VWServer.writeMessageToExceptionFile("Got exception logging through JNI in javaSideLogToVWTRACE (\"" + message + "\") \n Exception is : " + e.getMessage());
            }
        } else {
            String traceFileName = null;
            try {
                traceFileName = this.fnswLocalTmp + this.fSeparator + "vwtrace";
                PrintWriter traceFileVWServer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(traceFileName, true)), true);
                traceFileVWServer.println(timeStampFormatter.format(new Date()) + " (" + Thread.currentThread().toString() + ") " + "JAVA VWServer, server ID " + this.serverId + " : " + message);
                traceFileVWServer.close();
            }
            catch (Exception e) {
                VWServer.writeMessageToExceptionFile("Got exception logging from java code in javaSideLogToVWTRACE (\"" + message + "\") \n Exception is : " + e.getMessage() + "\nTraceFileName is : " + traceFileName);
            }
        }
    }

    private static synchronized void dumpExceptionStack(Throwable ex) {
        try {
            PrintWriter EXC_FileVWServer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(EXC_FileName, true)), true);
            if (EXC_FileName.equals("jVWServerX.exc")) {
                EXC_FileVWServer.println("This file's name is \"jVWServerX.exc\", so the problem happened early in VWServer.main(), before the log file directory name was known, probably during or shortly after command argument processing.\n");
            }
            EXC_FileVWServer.println(fullDateFormatter.format(new Date()));
            ex.printStackTrace(EXC_FileVWServer);
            EXC_FileVWServer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void writeMessageToExceptionFile(String message) {
        try {
            PrintWriter EXC_FileVWServer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(EXC_FileName, true)), true);
            if (EXC_FileName.equals("jVWServerX.exc")) {
                EXC_FileVWServer.println("This file's name is \"jVWServerX.exc\", so the problem happened early in VWServer.main(),  before the log file directory name was known,probably during or shortly after command argument processing.\n");
            }
            EXC_FileVWServer.println(fullDateFormatter.format(new Date()) + " " + message);
            EXC_FileVWServer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

